/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.clientbound.ExportMusicPacket;

public class CommandExport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"musicexport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.musicExport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int musicExport(class_2168 stack, String name) {
        Mod.LOGGER.debug("Music export called. name: {}", (Object)name);
        if (stack.method_9228() == null) {
            Mod.LOGGER.error("Command entity is not found");
            return 0;
        }
        class_1297 commander = stack.method_9228();
        if (!(commander instanceof class_3222)) {
            Mod.LOGGER.error("Command entity is not a player");
            return 0;
        }
        class_3222 player = (class_3222)commander;
        ExportMusicPacket pack = new ExportMusicPacket(name);
        Mod.sendToClient(player, pack);
        return 1;
    }

    public static boolean doExport(class_1657 player, String name) {
        String dir = "music_sheets";
        String filename = name + ".sheet";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (class_1799 s : player.method_5877()) {
            if (!(s.method_7909() instanceof ItemMusicSheet)) continue;
            UUID id = (UUID)s.method_57824(Items.SHEET_ID);
            int ver = (Integer)s.method_57825(Items.SHEET_VERSION, (Object)-1);
            int length = (Integer)s.method_57825(Items.SHEET_LENGTH, (Object)0);
            if (id != null && ver >= 0 && length > 0) {
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        Float volume;
                        Byte highlightInterval;
                        Byte prevIns;
                        Boolean piLocked;
                        class_2487 tag = new class_2487();
                        tag.method_10569("ver", ver);
                        tag.method_25927("id", id);
                        tag.method_10569("l", length);
                        tag.method_10569("generation", ((Integer)s.method_57825(Items.SHEET_GENERATION, (Object)0)).intValue());
                        Byte bps = (Byte)s.method_57824(Items.SHEET_BPS);
                        if (bps != null) {
                            tag.method_10567("bps", bps.byteValue());
                        }
                        if ((piLocked = (Boolean)s.method_57824(Items.SHEET_PREV_INSTRUMENT_LOCKED)) != null) {
                            tag.method_10556("piLocked", piLocked.booleanValue());
                        }
                        if ((prevIns = (Byte)s.method_57824(Items.SHEET_PREV_INSTRUMENT)) != null) {
                            tag.method_10567("prevIns", prevIns.byteValue());
                        }
                        String title = (String)s.method_57824(Items.SHEET_TITLE);
                        String author = (String)s.method_57824(Items.SHEET_AUTHOR);
                        if (title != null && author != null) {
                            tag.method_10582("title", title);
                            tag.method_10582("author", author);
                        }
                        if ((highlightInterval = (Byte)s.method_57824(Items.SHEET_HIGHLIGHT_INTERVAL)) != null) {
                            tag.method_10567("hl", highlightInterval.byteValue());
                        }
                        if ((volume = (Float)s.method_57824(Items.SHEET_VOLUME)) != null) {
                            tag.method_10548("vol", volume.floatValue());
                        }
                        NoteEvent.fillNBTFromArray(data.notes(), tag);
                        try {
                            class_2507.method_10630((class_2487)tag, (Path)Path.of(filepath, new String[0]));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }
}

